<?php
use App\Core\Helpers;
$title = 'Resultados - ' . ($q['q'] ?: 'Buscar');
?>
<div class="d-flex align-items-center justify-content-between mb-3">
  <h1 class="h4 mb-0">Resultados</h1>
  <div class="d-flex gap-2">
    <a class="btn btn-sm btn-outline-secondary" href="/">Nova busca</a>
    <button class="btn btn-sm btn-outline-primary" onclick="useMyLocation()">Perto de mim</button>
  </div>
</div>

<form class="card p-3 mb-3" method="get" action="/buscar">
  <div class="row g-2">
    <div class="col-lg-4">
      <label class="form-label">Termo</label>
      <input class="form-control" name="q" value="<?= Helpers::e($q['q']) ?>" />
    </div>
    <div class="col-lg-2">
      <label class="form-label">Cidade</label>
      <input class="form-control" name="city" value="<?= Helpers::e($q['city']) ?>" />
    </div>
    <div class="col-lg-2">
      <label class="form-label">Bairro</label>
      <input class="form-control" name="district" value="<?= Helpers::e($q['district']) ?>" placeholder="Opcional" />
    </div>
    <div class="col-lg-2">
      <label class="form-label">Tipo</label>
      <select class="form-select" name="type">
        <option value="">Todos</option>
        <option value="company" <?= $q['type']==='company'?'selected':'' ?>>Empresa</option>
        <option value="professional" <?= $q['type']==='professional'?'selected':'' ?>>Profissional</option>
      </select>
    </div>
    <div class="col-lg-2">
      <label class="form-label">Categoria</label>
      <select class="form-select" name="category">
        <option value="">Todas</option>
        <?php foreach (($categories ?? []) as $c): ?>
          <option value="<?= Helpers::e($c['slug']) ?>" <?= $q['category']===$c['slug']?'selected':'' ?>>
            <?= Helpers::e($c['name']) ?>
          </option>
        <?php endforeach; ?>
      </select>
    </div>

    <div class="col-lg-2">
      <label class="form-label">Raio (km)</label>
      <select class="form-select" name="radius">
        <option value="">—</option>
        <?php foreach ([1,3,5,10,20] as $r): ?>
          <option value="<?= $r ?>" <?= (string)$q['radius']===(string)$r?'selected':'' ?>><?= $r ?> km</option>
        <?php endforeach; ?>
      </select>
      <div class="form-text">Para raio: use “Perto de mim”.</div>
    </div>

    <div class="col-lg-2">
      <label class="form-label">Avaliação mín.</label>
      <select class="form-select" name="min_rating">
        <option value="">—</option>
        <?php foreach ([3,4,5] as $r): ?>
          <option value="<?= $r ?>" <?= (string)$q['min_rating']===(string)$r?'selected':'' ?>><?= $r ?>+</option>
        <?php endforeach; ?>
      </select>
    </div>

    <div class="col-lg-2 d-flex align-items-end">
      <div class="form-check">
        <input class="form-check-input" type="checkbox" name="open_now" value="1" <?= $q['open_now']?'checked':'' ?> />
        <label class="form-check-label">Aberto agora</label>
      </div>
    </div>

    <div class="col-lg-2">
      <label class="form-label">Ordenar</label>
      <select class="form-select" name="sort">
        <option value="relevance" <?= $q['sort']==='relevance'?'selected':'' ?>>Relevância</option>
        <option value="near" <?= $q['sort']==='near'?'selected':'' ?>>Mais perto</option>
        <option value="rating" <?= $q['sort']==='rating'?'selected':'' ?>>Melhor avaliação</option>
        <option value="recent" <?= $q['sort']==='recent'?'selected':'' ?>>Mais recentes</option>
      </select>
    </div>

    <input type="hidden" name="lat" value="<?= Helpers::e($q['lat']) ?>">
    <input type="hidden" name="lng" value="<?= Helpers::e($q['lng']) ?>">

    <div class="col-12 mt-2">
      <button class="btn btn-primary">Aplicar filtros</button>
    </div>
  </div>
</form>

<div class="row g-3">
  <div class="col-lg-6">
    <?php if (empty($results)): ?>
      <div class="alert alert-warning">Nenhum resultado encontrado.</div>
    <?php else: ?>
      <div class="small text-muted mb-2"><?= count($results) ?> resultados</div>
      <?php foreach ($results as $r): ?>
        <div class="card card-hover mb-2" data-slug="<?= Helpers::e($r['slug']) ?>">
          <div class="card-body">
            <div class="d-flex justify-content-between align-items-start">
              <div>
                <a class="h6 text-decoration-none" href="/perfil/<?= Helpers::e($r['slug']) ?>"><?= Helpers::e($r['title']) ?></a>
                <div class="small text-muted"><?= Helpers::e($r['district'] ?? '') ?> · <?= Helpers::e($r['city'] ?? '') ?></div>
                <div class="small">
                  <span class="badge text-bg-<?= ($r['plan']==='premium')?'warning':'secondary' ?>"><?= Helpers::e($r['plan']) ?></span>
                  <span class="badge text-bg-light border">⭐ <?= number_format((float)$r['avg_rating'], 1) ?></span>
                  <?php if (!empty($r['distance_km'])): ?>
                    <span class="badge text-bg-light border"><?= number_format((float)$r['distance_km'], 1) ?> km</span>
                  <?php endif; ?>
                </div>
              </div>
              <span class="badge text-bg-<?= $r['type']==='company'?'primary':'success' ?>"><?= $r['type']==='company'?'Empresa':'Profissional' ?></span>
            </div>
          </div>
        </div>
      <?php endforeach; ?>
    <?php endif; ?>
  </div>

  <div class="col-lg-6">
    <div class="card shadow-sm">
      <div class="card-body p-0">
        <div id="map" style="height: 520px;"></div>
      </div>
    </div>
  </div>
</div>

<script>
window.__RESULTS__ = <?= json_encode(array_map(fn($r)=>[
  'title'=>$r['title'],'slug'=>$r['slug'],'lat'=>$r['lat'],'lng'=>$r['lng']
], $results ?? [])) ?>;
window.__CENTER__ = <?= json_encode($center) ?>;
</script>
