<?php
use App\Core\Helpers;
use App\Core\Auth;
use App\Core\CSRF;

$title = ($listing['title'] ?? 'Perfil') . ' - ' . ($listing['city'] ?? '');
$plan = $listing['plan'] ?? 'free';

function weekdayLabel($w){
  return ['Dom','Seg','Ter','Qua','Qui','Sex','Sáb'][$w] ?? '';
}
function isOpenNow($hours): bool {
  $w = (int)date('w');
  if (empty($hours[$w]) || !empty($hours[$w]['is_closed'])) return false;
  $now = date('H:i:s');
  $o = $hours[$w]['open_time'] ?? null; $c = $hours[$w]['close_time'] ?? null;
  if (!$o || !$c) return false;
  return ($o <= $now && $c >= $now);
}
$openNow = isOpenNow($hours ?? []);
?>
<div class="row g-3">
  <div class="col-lg-8">
    <div class="d-flex align-items-start justify-content-between">
      <div>
        <h1 class="h3 mb-1"><?= Helpers::e($listing['title'] ?? '') ?></h1>
        <div class="text-muted"><?= Helpers::e(($listing['district'] ?? '') . ' · ' . ($listing['city'] ?? '')) ?></div>
        <div class="mt-2 d-flex flex-wrap gap-2">
          <?php foreach (($cats ?? []) as $c): ?>
            <a class="badge text-bg-secondary text-decoration-none" href="/categoria/<?= Helpers::e($c['slug']) ?>"><?= Helpers::e($c['name']) ?></a>
          <?php endforeach; ?>
          <span class="badge text-bg-<?= $openNow?'success':'secondary' ?>"><?= $openNow?'Aberto agora':'Fechado' ?></span>
          <span class="badge text-bg-<?= $plan==='premium'?'warning':'light border' ?>"><?= Helpers::e($plan) ?></span>
          <span class="badge text-bg-light border">⭐ <?= number_format((float)$listing['avg_rating'], 1) ?> (<?= (int)$listing['reviews_count'] ?>)</span>
        </div>
      </div>

      <div class="d-flex flex-column gap-2 align-items-end">
        <?php if (!empty($listing['whatsapp'])): ?>
          <a class="btn btn-success" target="_blank" href="https://wa.me/<?= Helpers::e(preg_replace('/\D+/', '', $listing['whatsapp'])) ?>">WhatsApp</a>
        <?php endif; ?>
        <?php if (!empty($listing['phone'])): ?>
          <a class="btn btn-outline-primary" href="tel:<?= Helpers::e($listing['phone']) ?>">Ligar</a>
        <?php endif; ?>
        <?php if (Auth::check()): ?>
          <form method="post" action="/favoritar">
            <input type="hidden" name="_csrf" value="<?= CSRF::token() ?>">
            <input type="hidden" name="listing_id" value="<?= (int)$listing['id'] ?>">
            <button class="btn btn-outline-dark"><?= $isFav?'★ Favoritado':'☆ Favoritar' ?></button>
          </form>
        <?php else: ?>
          <a class="btn btn-outline-dark" href="/entrar">Entrar para favoritar</a>
        <?php endif; ?>
      </div>
    </div>

    <?php if (!empty($listing['bio'])): ?>
      <div class="card mt-3">
        <div class="card-body">
          <h2 class="h6">Sobre</h2>
          <p class="mb-0"><?= nl2br(Helpers::e($listing['bio'])) ?></p>
        </div>
      </div>
    <?php endif; ?>

    <?php if (!empty($services)): ?>
      <div class="card mt-3">
        <div class="card-body">
          <h2 class="h6 mb-3">Serviços</h2>
          <div class="list-group">
            <?php foreach ($services as $s): if (!$s['active']) continue; ?>
              <div class="list-group-item">
                <div class="d-flex justify-content-between">
                  <strong><?= Helpers::e($s['name']) ?></strong>
                  <?php if ($s['price_from'] !== null): ?>
                    <span class="text-muted">a partir de R$ <?= number_format((float)$s['price_from'],2,',','.') ?></span>
                  <?php endif; ?>
                </div>
                <?php if (!empty($s['description'])): ?>
                  <div class="small text-muted"><?= Helpers::e($s['description']) ?></div>
                <?php endif; ?>
              </div>
            <?php endforeach; ?>
          </div>

          <?php if (($listing['budget_button_enabled'] ?? 0) && ($plan==='premium')): ?>
            <a class="btn btn-warning mt-3" href="#contato">Solicitar orçamento</a>
          <?php endif; ?>
        </div>
      </div>
    <?php endif; ?>

    <div class="card mt-3" id="contato">
      <div class="card-body">
        <h2 class="h6">Contato / Chat (MVP)</h2>
        <?php if (!empty($_GET['lead'])): ?>
          <div class="alert alert-success">Mensagem enviada!</div>
        <?php endif; ?>
        <form method="post" action="/contato">
          <input type="hidden" name="_csrf" value="<?= CSRF::token() ?>">
          <input type="hidden" name="listing_id" value="<?= (int)$listing['id'] ?>">
          <input type="hidden" name="slug" value="<?= Helpers::e($listing['slug']) ?>">
          <div class="row g-2">
            <div class="col-md-4">
              <label class="form-label">Seu nome</label>
              <input class="form-control" name="name" required>
            </div>
            <div class="col-md-4">
              <label class="form-label">Telefone</label>
              <input class="form-control" name="phone">
            </div>
            <div class="col-md-4">
              <label class="form-label">E-mail</label>
              <input class="form-control" name="email" type="email">
            </div>
            <div class="col-12">
              <label class="form-label">Mensagem</label>
              <textarea class="form-control" name="message" rows="3" required></textarea>
            </div>
          </div>
          <button class="btn btn-primary mt-2">Enviar</button>
        </form>
      </div>
    </div>

    <div class="card mt-3">
      <div class="card-body">
        <h2 class="h6">Avaliações</h2>
        <?php if (Auth::check() && (Auth::user()['role'] ?? 'user') === 'user'): ?>
          <form method="post" action="/avaliar" class="border rounded p-3 mb-3">
            <input type="hidden" name="_csrf" value="<?= CSRF::token() ?>">
            <input type="hidden" name="listing_id" value="<?= (int)$listing['id'] ?>">
            <input type="hidden" name="slug" value="<?= Helpers::e($listing['slug']) ?>">
            <div class="row g-2">
              <div class="col-md-2">
                <label class="form-label">Nota</label>
                <select class="form-select" name="rating">
                  <?php for ($i=5;$i>=1;$i--): ?>
                    <option value="<?= $i ?>"><?= $i ?></option>
                  <?php endfor; ?>
                </select>
              </div>
              <div class="col-md-10">
                <label class="form-label">Comentário</label>
                <input class="form-control" name="comment" required minlength="5">
              </div>
            </div>
            <button class="btn btn-outline-primary mt-2">Enviar avaliação</button>
            <div class="form-text">Avaliações passam por moderação (anti-spam).</div>
          </form>
        <?php endif; ?>

        <?php if (empty($reviews)): ?>
          <div class="text-muted">Ainda não há avaliações aprovadas.</div>
        <?php else: ?>
          <div class="vstack gap-2">
            <?php foreach ($reviews as $r): ?>
              <div class="border rounded p-3 bg-white">
                <div class="d-flex justify-content-between">
                  <strong><?= Helpers::e($r['user_name'] ?? 'Usuário') ?></strong>
                  <span>⭐ <?= (int)$r['rating'] ?></span>
                </div>
                <div><?= nl2br(Helpers::e($r['comment'])) ?></div>
                <div class="small text-muted"><?= Helpers::e($r['created_at']) ?></div>

                <?php if (!empty($r['reply_comment'])): ?>
                  <div class="mt-2 p-2 bg-light rounded">
                    <strong>Resposta:</strong> <?= nl2br(Helpers::e($r['reply_comment'])) ?>
                  </div>
                <?php endif; ?>

                <?php if (Auth::check() && in_array(Auth::user()['role'] ?? '', ['professional','company','admin'], true)): ?>
                  <form class="mt-2" method="post" action="/responder-avaliacao">
                    <input type="hidden" name="_csrf" value="<?= CSRF::token() ?>">
                    <input type="hidden" name="review_id" value="<?= (int)$r['id'] ?>">
                    <input type="hidden" name="listing_id" value="<?= (int)$listing['id'] ?>">
                    <div class="input-group">
                      <input class="form-control" name="comment" placeholder="Responder..." value="<?= Helpers::e($r['reply_comment'] ?? '') ?>">
                      <button class="btn btn-outline-secondary">Salvar</button>
                    </div>
                  </form>
                <?php endif; ?>

                <form method="post" action="/denunciar" class="mt-2">
                  <input type="hidden" name="_csrf" value="<?= CSRF::token() ?>">
                  <input type="hidden" name="target_type" value="review">
                  <input type="hidden" name="target_id" value="<?= (int)$r['id'] ?>">
                  <div class="input-group input-group-sm">
                    <input class="form-control" name="reason" placeholder="Denunciar avaliação (motivo)" required>
                    <button class="btn btn-outline-danger">Denunciar</button>
                  </div>
                </form>
              </div>
            <?php endforeach; ?>
          </div>
        <?php endif; ?>

      </div>
    </div>

  </div>

  <div class="col-lg-4">
    <div class="card shadow-sm">
      <div class="card-body">
        <h2 class="h6">Localização</h2>
        <div class="small text-muted mb-2">
          <?= Helpers::e(trim(($listing['street'] ?? '') . ' ' . ($listing['number'] ?? '') . ', ' . ($listing['district'] ?? '') . ' - ' . ($listing['city'] ?? '') . '/' . ($listing['state'] ?? ''))) ?>
        </div>
        <div id="profileMap" style="height: 260px;"></div>
        <?php if (!empty($listing['lat']) && !empty($listing['lng'])): ?>
          <div class="d-flex gap-2 mt-2">
            <a class="btn btn-sm btn-outline-primary w-100" target="_blank" href="https://www.google.com/maps/dir/?api=1&destination=<?= Helpers::e($listing['lat']) ?>,<?= Helpers::e($listing['lng']) ?>">Como chegar</a>
          </div>
        <?php endif; ?>
        <form method="post" action="/denunciar" class="mt-3">
          <input type="hidden" name="_csrf" value="<?= CSRF::token() ?>">
          <input type="hidden" name="target_type" value="listing">
          <input type="hidden" name="target_id" value="<?= (int)$listing['id'] ?>">
          <div class="input-group input-group-sm">
            <input class="form-control" name="reason" placeholder="Denunciar perfil (motivo)" required>
            <button class="btn btn-outline-danger">Denunciar</button>
          </div>
        </form>
      </div>
    </div>

    <div class="card mt-3">
      <div class="card-body">
        <h2 class="h6">Horários</h2>
        <div class="small">
          <?php for ($d=0;$d<=6;$d++): $h = $hours[$d] ?? null; ?>
            <div class="d-flex justify-content-between">
              <span><?= weekdayLabel($d) ?></span>
              <span class="text-muted">
                <?php if (!$h || !empty($h['is_closed'])): ?>
                  Fechado
                <?php else: ?>
                  <?= Helpers::e(substr((string)$h['open_time'],0,5)) ?> - <?= Helpers::e(substr((string)$h['close_time'],0,5)) ?>
                <?php endif; ?>
              </span>
            </div>
          <?php endfor; ?>
        </div>
      </div>
    </div>

    <?php if (!empty($media)): ?>
      <div class="card mt-3">
        <div class="card-body">
          <h2 class="h6">Fotos</h2>
          <div class="row g-2">
            <?php foreach ($media as $m): if ($m['type'] !== 'gallery') continue; ?>
              <div class="col-6">
                <img class="img-fluid rounded" src="/<?= Helpers::e($m['path']) ?>" alt="foto">
              </div>
            <?php endforeach; ?>
          </div>
        </div>
      </div>
    <?php endif; ?>

  </div>
</div>

<script>
window.__PROFILE__ = <?= json_encode([
  'title'=>$listing['title'] ?? '',
  'lat'=>$listing['lat'] ?? null,
  'lng'=>$listing['lng'] ?? null
]) ?>;
</script>
