<?php
use App\Core\Auth;
use App\Core\Helpers;
$u = Auth::user();
$title = $title ?? ($_ENV['APP_NAME'] ?? 'Guia Local');
$metaDescription = $metaDescription ?? 'Encontre empresas e profissionais na sua cidade.';
?>
<!doctype html>
<html lang="pt-br">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= Helpers::e($title) ?></title>
  <meta name="description" content="<?= Helpers::e($metaDescription) ?>">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css">
  <link rel="stylesheet" href="https://unpkg.com/leaflet.markercluster@1.5.3/dist/MarkerCluster.css">
  <link rel="stylesheet" href="https://unpkg.com/leaflet.markercluster@1.5.3/dist/MarkerCluster.Default.css">
  <link rel="stylesheet" href="/assets/styles.css">
</head>
<body class="bg-light">
<nav class="navbar navbar-expand-lg navbar-dark bg-dark">
  <div class="container">
    <a class="navbar-brand" href="/"><?= Helpers::e($_ENV['APP_NAME'] ?? 'Guia Local') ?></a>
    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#nav">
      <span class="navbar-toggler-icon"></span>
    </button>
    <div id="nav" class="collapse navbar-collapse">
      <ul class="navbar-nav me-auto">
        <li class="nav-item"><a class="nav-link" href="/buscar">Buscar</a></li>
      </ul>
      <ul class="navbar-nav ms-auto">
        <?php if ($u): ?>
          <?php if (($u['role'] ?? '') === 'admin'): ?>
            <li class="nav-item"><a class="nav-link" href="/admin">Admin</a></li>
          <?php endif; ?>
          <?php if (($u['role'] ?? '') !== 'user'): ?>
            <li class="nav-item"><a class="nav-link" href="/painel">Painel</a></li>
          <?php endif; ?>
          <li class="nav-item"><span class="navbar-text me-2">Olá, <?= Helpers::e($u['name'] ?? '') ?></span></li>
          <li class="nav-item"><a class="nav-link" href="/sair">Sair</a></li>
        <?php else: ?>
          <li class="nav-item"><a class="nav-link" href="/entrar">Entrar</a></li>
          <li class="nav-item"><a class="nav-link" href="/registrar">Criar conta</a></li>
        <?php endif; ?>
      </ul>
    </div>
  </div>
</nav>

<main class="container py-4">
