<?php
use App\Core\Helpers;
use App\Core\CSRF;

$title = 'Editar perfil';
?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h1 class="h4 mb-0">Editar perfil</h1>
  <a class="btn btn-sm btn-outline-secondary" href="/painel">Voltar</a>
</div>

<?php if (!empty($_GET['ok'])): ?>
  <div class="alert alert-success">Perfil atualizado.</div>
<?php endif; ?>
<?php if (!empty($_GET['geo']) && $_GET['geo']==='fail'): ?>
  <div class="alert alert-warning">Geocoding falhou. Ajuste manualmente o pino.</div>
<?php endif; ?>

<form method="post" action="/painel/perfil" class="card p-3 mb-3">
  <input type="hidden" name="_csrf" value="<?= CSRF::token() ?>">
  <div class="row g-2">
    <div class="col-md-8">
      <label class="form-label">Nome / Título</label>
      <input class="form-control" name="title" value="<?= Helpers::e($listing['title'] ?? '') ?>" required>
    </div>
    <div class="col-md-4">
      <label class="form-label">Orçamento (premium)</label>
      <div class="form-check mt-2">
        <input class="form-check-input" type="checkbox" name="budget_button_enabled" value="1" <?= !empty($listing['budget_button_enabled'])?'checked':'' ?>>
        <label class="form-check-label">Mostrar botão “Orçamento”</label>
      </div>
    </div>

    <div class="col-12">
      <label class="form-label">Descrição</label>
      <textarea class="form-control" name="bio" rows="3"><?= Helpers::e($listing['bio'] ?? '') ?></textarea>
    </div>

    <div class="col-md-4">
      <label class="form-label">Telefone</label>
      <input class="form-control" name="phone" value="<?= Helpers::e($listing['phone'] ?? '') ?>">
    </div>
    <div class="col-md-4">
      <label class="form-label">WhatsApp (com DDI/DDD)</label>
      <input class="form-control" name="whatsapp" value="<?= Helpers::e($listing['whatsapp'] ?? '') ?>">
    </div>
    <div class="col-md-4">
      <label class="form-label">E-mail público</label>
      <input class="form-control" type="email" name="email_public" value="<?= Helpers::e($listing['email_public'] ?? '') ?>">
    </div>
    <div class="col-12">
      <label class="form-label">Website</label>
      <input class="form-control" name="website" value="<?= Helpers::e($listing['website'] ?? '') ?>">
    </div>

    <hr class="my-3">

    <div class="col-md-6">
      <label class="form-label">Categorias</label>
      <div class="d-flex flex-wrap gap-2">
        <?php foreach (($categories ?? []) as $c): ?>
          <div class="form-check">
            <input class="form-check-input" type="checkbox" name="category_ids[]" value="<?= (int)$c['id'] ?>" <?= in_array((int)$c['id'], $selected ?? [], true)?'checked':'' ?>>
            <label class="form-check-label"><?= Helpers::e($c['name']) ?></label>
          </div>
        <?php endforeach; ?>
      </div>
    </div>

    <div class="col-md-6">
      <label class="form-label">Endereço</label>
      <div class="row g-2">
        <div class="col-8"><input class="form-control" name="street" placeholder="Rua" value="<?= Helpers::e($listing['street'] ?? '') ?>"></div>
        <div class="col-4"><input class="form-control" name="number" placeholder="Número" value="<?= Helpers::e($listing['number'] ?? '') ?>"></div>
        <div class="col-6"><input class="form-control" name="district" placeholder="Bairro" value="<?= Helpers::e($listing['district'] ?? '') ?>"></div>
        <div class="col-4"><input class="form-control" name="city" placeholder="Cidade" value="<?= Helpers::e($listing['city'] ?? '') ?>"></div>
        <div class="col-2"><input class="form-control" name="state" placeholder="UF" value="<?= Helpers::e($listing['state'] ?? '') ?>"></div>
        <div class="col-6"><input class="form-control" name="zipcode" placeholder="CEP" value="<?= Helpers::e($listing['zipcode'] ?? '') ?>"></div>

        <div class="col-6">
          <label class="form-label">Lat</label>
          <input class="form-control" name="lat" value="<?= Helpers::e((string)($listing['lat'] ?? '')) ?>">
        </div>
        <div class="col-6">
          <label class="form-label">Lng</label>
          <input class="form-control" name="lng" value="<?= Helpers::e((string)($listing['lng'] ?? '')) ?>">
        </div>
      </div>

      <div class="mt-2 small text-muted">
        Você pode <strong>geocodificar</strong> pelo endereço completo e depois <strong>ajustar no mapa</strong> arrastando o pino.
      </div>
    </div>
  </div>

  <button class="btn btn-primary mt-3">Salvar</button>
</form>

<form method="post" action="/painel/endereco-geocode" class="card p-3 mb-3">
  <input type="hidden" name="_csrf" value="<?= CSRF::token() ?>">
  <h2 class="h6">Geocoding (Nominatim)</h2>
  <div class="input-group">
    <input class="form-control" name="address_text" placeholder="Ex.: Rua X, 123, Bairro, Cidade, UF" required>
    <button class="btn btn-outline-primary">Geocodificar</button>
  </div>
</form>

<div class="card mb-3">
  <div class="card-body">
    <h2 class="h6">Ajuste manual (arraste o pino / clique no mapa)</h2>
    <div id="pinMap" style="height: 320px;"></div>
    <div class="form-text">Depois clique em “Salvar” no formulário principal.</div>
  </div>
</div>

<div class="card mb-3" id="midia">
  <div class="card-body">
    <h2 class="h6">Mídia</h2>

    <div class="row g-3">
      <div class="col-md-6">
        <form method="post" action="/painel/upload-logo" enctype="multipart/form-data">
          <input type="hidden" name="_csrf" value="<?= CSRF::token() ?>">
          <label class="form-label">Logo (512px)</label>
          <input class="form-control" type="file" name="logo" accept="image/*" required>
          <button class="btn btn-outline-primary mt-2">Enviar logo</button>
        </form>
      </div>
      <div class="col-md-6">
        <form method="post" action="/painel/upload-galeria" enctype="multipart/form-data">
          <input type="hidden" name="_csrf" value="<?= CSRF::token() ?>">
          <label class="form-label">Galeria (várias fotos)</label>
          <input class="form-control" type="file" name="gallery[]" accept="image/*" multiple>
          <button class="btn btn-outline-primary mt-2">Enviar galeria</button>
        </form>
      </div>
    </div>

    <?php if (!empty($media)): ?>
      <div class="row g-2 mt-3">
        <?php foreach ($media as $m): ?>
          <div class="col-3">
            <img class="img-fluid rounded" src="/<?= Helpers::e($m['path']) ?>">
          </div>
        <?php endforeach; ?>
      </div>
    <?php endif; ?>
  </div>
</div>

<div class="card mb-3" id="servicos">
  <div class="card-body">
    <h2 class="h6">Serviços</h2>

    <form method="post" action="/painel/servico" class="border rounded p-3 mb-3">
      <input type="hidden" name="_csrf" value="<?= CSRF::token() ?>">
      <div class="row g-2">
        <div class="col-md-4"><input class="form-control" name="name" placeholder="Nome do serviço" required></div>
        <div class="col-md-4"><input class="form-control" name="price_from" placeholder="Preço a partir de (ex.: 120.00)"></div>
        <div class="col-md-2 d-flex align-items-center">
          <div class="form-check">
            <input class="form-check-input" type="checkbox" name="active" value="1" checked>
            <label class="form-check-label">Ativo</label>
          </div>
        </div>
        <div class="col-12"><input class="form-control" name="description" placeholder="Descrição"></div>
      </div>
      <button class="btn btn-outline-primary mt-2">Salvar serviço</button>
    </form>

    <?php if (!empty($services)): ?>
      <div class="list-group">
        <?php foreach ($services as $s): ?>
          <div class="list-group-item">
            <div class="d-flex justify-content-between align-items-center">
              <div>
                <strong><?= Helpers::e($s['name']) ?></strong>
                <div class="small text-muted"><?= Helpers::e($s['description'] ?? '') ?></div>
              </div>
              <div class="d-flex gap-2">
                <span class="badge text-bg-light border"><?= $s['price_from']!==null ? 'R$ '.number_format((float)$s['price_from'],2,',','.') : '—' ?></span>
                <span class="badge text-bg-<?= $s['active']? 'success':'secondary' ?>"><?= $s['active']?'ativo':'inativo' ?></span>
                <form method="post" action="/painel/servico-excluir" onsubmit="return confirm('Excluir?')">
                  <input type="hidden" name="_csrf" value="<?= CSRF::token() ?>">
                  <input type="hidden" name="service_id" value="<?= (int)$s['id'] ?>">
                  <button class="btn btn-sm btn-outline-danger">Excluir</button>
                </form>
              </div>
            </div>
          </div>
        <?php endforeach; ?>
      </div>
    <?php endif; ?>
  </div>
</div>

<div class="card" id="horarios">
  <div class="card-body">
    <h2 class="h6">Horários</h2>
    <form method="post" action="/painel/horarios">
      <input type="hidden" name="_csrf" value="<?= CSRF::token() ?>">
      <div class="table-responsive">
        <table class="table table-sm align-middle">
          <thead><tr><th>Dia</th><th>Abertura</th><th>Fechamento</th><th>Fechado</th></tr></thead>
          <tbody>
            <?php for ($d=0;$d<=6;$d++): $h = $hours[$d] ?? null; ?>
              <tr>
                <td><?= ['Dom','Seg','Ter','Qua','Qui','Sex','Sáb'][$d] ?></td>
                <td><input class="form-control form-control-sm" type="time" name="open[<?= $d ?>]" value="<?= Helpers::e(substr((string)($h['open_time'] ?? ''),0,5)) ?>"></td>
                <td><input class="form-control form-control-sm" type="time" name="close[<?= $d ?>]" value="<?= Helpers::e(substr((string)($h['close_time'] ?? ''),0,5)) ?>"></td>
                <td><input class="form-check-input" type="checkbox" name="closed[<?= $d ?>]" value="1" <?= !empty($h['is_closed'])?'checked':'' ?>></td>
              </tr>
            <?php endfor; ?>
          </tbody>
        </table>
      </div>
      <button class="btn btn-outline-primary">Salvar horários</button>
    </form>
  </div>
</div>
