<?php
use App\Core\Helpers;
$title = 'Categoria: ' . ($cat['name'] ?? '');
?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h1 class="h4 mb-0"><?= Helpers::e($cat['name'] ?? '') ?></h1>
  <a class="btn btn-sm btn-outline-secondary" href="/buscar">Ver busca completa</a>
</div>

<?php if (empty($results)): ?>
  <div class="alert alert-warning">Nenhum resultado para esta categoria.</div>
<?php else: ?>
  <div class="row g-2">
    <?php foreach ($results as $r): ?>
      <div class="col-md-6">
        <div class="card card-hover">
          <div class="card-body">
            <a class="h6 text-decoration-none" href="/perfil/<?= Helpers::e($r['slug']) ?>"><?= Helpers::e($r['title']) ?></a>
            <div class="small text-muted"><?= Helpers::e($r['district'] ?? '') ?> · <?= Helpers::e($r['city'] ?? '') ?></div>
            <div class="small mt-1">⭐ <?= number_format((float)$r['avg_rating'],1) ?></div>
          </div>
        </div>
      </div>
    <?php endforeach; ?>
  </div>
<?php endif; ?>
