<?php
use App\Core\CSRF;
use App\Core\Helpers;
$title = 'Criar conta';
?>
<div class="row justify-content-center">
  <div class="col-md-6">
    <h1 class="h4 mb-3">Criar conta</h1>
    <?php if (!empty($error)): ?><div class="alert alert-danger"><?= Helpers::e($error) ?></div><?php endif; ?>
    <?php if (!empty($success)): ?><div class="alert alert-success"><?= Helpers::e($success) ?></div><?php endif; ?>
    <form method="post" action="/registrar" class="card p-3">
      <input type="hidden" name="_csrf" value="<?= CSRF::token() ?>">
      <div class="row g-2">
        <div class="col-md-6">
          <label class="form-label">Nome</label>
          <input class="form-control" name="name" required>
        </div>
        <div class="col-md-6">
          <label class="form-label">Tipo de conta</label>
          <select class="form-select" name="role">
            <option value="user">Usuário</option>
            <option value="professional">Profissional</option>
            <option value="company">Empresa</option>
          </select>
        </div>
        <div class="col-12">
          <label class="form-label">E-mail</label>
          <input class="form-control" type="email" name="email" required>
        </div>
        <div class="col-12">
          <label class="form-label">Senha (mín. 8)</label>
          <input class="form-control" type="password" name="password" required minlength="8">
        </div>
      </div>
      <button class="btn btn-primary mt-3">Cadastrar</button>
      <div class="small mt-2"><a href="/entrar">Já tenho conta</a></div>
    </form>
  </div>
</div>
