<?php
use App\Core\Helpers;
$title = 'Admin - Dashboard';
?>
<h1 class="h4 mb-3">Admin - Dashboard</h1>
<div class="row g-3">
  <?php
    $cards = [
      ['Users','users'],
      ['Listings','listings'],
      ['Reviews','reviews'],
      ['Leads','leads'],
      ['Pend. Listings','pending_listings'],
      ['Pend. Reviews','pending_reviews'],
    ];
  ?>
  <?php foreach ($cards as [$label,$k]): ?>
    <div class="col-md-4">
      <div class="card">
        <div class="card-body">
          <div class="text-muted small"><?= Helpers::e($label) ?></div>
          <div class="display-6"><?= (int)($counts[$k] ?? 0) ?></div>
        </div>
      </div>
    </div>
  <?php endforeach; ?>
</div>

<div class="mt-3 d-flex gap-2 flex-wrap">
  <a class="btn btn-outline-primary" href="/admin/listings">Listings</a>
  <a class="btn btn-outline-primary" href="/admin/categorias">Categorias</a>
  <a class="btn btn-outline-primary" href="/admin/avaliacoes">Avaliações</a>
  <a class="btn btn-outline-secondary" href="/admin/export/listings.csv">Export listings.csv</a>
  <a class="btn btn-outline-secondary" href="/admin/export/reviews.csv">Export reviews.csv</a>
</div>
