<?php
declare(strict_types=1);

namespace App\Models;

use PDO;

final class User extends Model
{
  public static function findByEmail(string $email): ?array
  {
    $st = self::pdo()->prepare("SELECT * FROM users WHERE email=? LIMIT 1");
    $st->execute([$email]);
    $row = $st->fetch(PDO::FETCH_ASSOC);
    return $row ?: null;
  }

  public static function findById(int $id): ?array
  {
    $st = self::pdo()->prepare("SELECT * FROM users WHERE id=? LIMIT 1");
    $st->execute([$id]);
    $row = $st->fetch(PDO::FETCH_ASSOC);
    return $row ?: null;
  }

  public static function create(string $name, string $email, string $hash, string $role, string $verifyHash): int
  {
    $st = self::pdo()->prepare("INSERT INTO users (name,email,password_hash,role,status,email_verify_token_hash) VALUES (?,?,?,?, 'pending', ?)");
    $st->execute([$name,$email,$hash,$role,$verifyHash]);
    return (int)self::pdo()->lastInsertId();
  }

  public static function verifyEmail(string $email, string $tokenHash): bool
  {
    $st = self::pdo()->prepare("UPDATE users SET status='active', email_verified_at=NOW(), email_verify_token_hash=NULL WHERE email=? AND email_verify_token_hash=?");
    $st->execute([$email,$tokenHash]);
    return $st->rowCount() === 1;
  }

  public static function setResetToken(int $id, string $hash, string $expiresAt): void
  {
    $st = self::pdo()->prepare("UPDATE users SET reset_token_hash=?, reset_token_expires_at=? WHERE id=?");
    $st->execute([$hash,$expiresAt,$id]);
  }

  public static function findByReset(string $email, string $hash): ?array
  {
    $st = self::pdo()->prepare("SELECT * FROM users WHERE email=? AND reset_token_hash=? AND reset_token_expires_at>=NOW() LIMIT 1");
    $st->execute([$email,$hash]);
    $row = $st->fetch(PDO::FETCH_ASSOC);
    return $row ?: null;
  }

  public static function updatePassword(int $id, string $hash): void
  {
    $st = self::pdo()->prepare("UPDATE users SET password_hash=?, reset_token_hash=NULL, reset_token_expires_at=NULL WHERE id=?");
    $st->execute([$hash,$id]);
  }
}
