<?php
declare(strict_types=1);

namespace App\Models;

use PDO;

final class Review extends Model
{
  public static function forListing(int $listingId): array
  {
    $st=self::pdo()->prepare("SELECT r.*, u.name user_name, rr.comment reply_comment, rr.created_at reply_created_at
      FROM reviews r
      JOIN users u ON u.id=r.user_id
      LEFT JOIN review_replies rr ON rr.review_id=r.id
      WHERE r.listing_id=? AND r.status='approved'
      ORDER BY r.created_at DESC");
    $st->execute([$listingId]);
    return $st->fetchAll() ?: [];
  }

  public static function create(int $listingId, int $userId, int $rating, string $comment): int
  {
    $st=self::pdo()->prepare("INSERT INTO reviews (listing_id,user_id,rating,comment,status) VALUES (?,?,?,?, 'pending')");
    $st->execute([$listingId,$userId,$rating,$comment]);
    return (int)self::pdo()->lastInsertId();
  }

  public static function reply(int $reviewId, int $listingId, string $comment): void
  {
    $pdo=self::pdo();
    $st=$pdo->prepare("INSERT INTO review_replies (review_id,listing_id,comment) VALUES (?,?,?) ON DUPLICATE KEY UPDATE comment=VALUES(comment)");
    $st->execute([$reviewId,$listingId,$comment]);
  }

  public static function adminList(string $status='pending'): array
  {
    $st=self::pdo()->prepare("SELECT r.*, l.title listing_title, u.email user_email
      FROM reviews r JOIN listings l ON l.id=r.listing_id JOIN users u ON u.id=r.user_id
      WHERE r.status=? ORDER BY r.created_at DESC LIMIT 200");
    $st->execute([$status]);
    return $st->fetchAll() ?: [];
  }

  public static function setStatus(int $id, string $status): void
  {
    $st=self::pdo()->prepare("UPDATE reviews SET status=? WHERE id=?");
    $st->execute([$status,$id]);
  }
}
