<?php
declare(strict_types=1);

namespace App\Models;

use PDO;

final class Category extends Model
{
  public static function allPopular(int $limit=8): array
  {
    $st = self::pdo()->prepare("SELECT c.*, COUNT(lc.listing_id) cnt
      FROM categories c
      LEFT JOIN listing_categories lc ON lc.category_id=c.id
      GROUP BY c.id
      ORDER BY cnt DESC, c.name ASC
      LIMIT ?");
    $st->bindValue(1, $limit, PDO::PARAM_INT);
    $st->execute();
    return $st->fetchAll() ?: [];
  }

  public static function all(): array
  {
    $st = self::pdo()->query("SELECT * FROM categories ORDER BY name ASC");
    return $st->fetchAll() ?: [];
  }

  public static function findBySlug(string $slug): ?array
  {
    $st = self::pdo()->prepare("SELECT * FROM categories WHERE slug=? LIMIT 1");
    $st->execute([$slug]);
    $row=$st->fetch(PDO::FETCH_ASSOC);
    return $row ?: null;
  }

  public static function upsert(?int $id, string $name, string $slug, string $type): int
  {
    if ($id) {
      $st=self::pdo()->prepare("UPDATE categories SET name=?, slug=?, type=? WHERE id=?");
      $st->execute([$name,$slug,$type,$id]);
      return $id;
    }
    $st=self::pdo()->prepare("INSERT INTO categories (name,slug,type) VALUES (?,?,?)");
    $st->execute([$name,$slug,$type]);
    return (int)self::pdo()->lastInsertId();
  }

  public static function delete(int $id): void
  {
    $st=self::pdo()->prepare("DELETE FROM categories WHERE id=?");
    $st->execute([$id]);
  }
}
