<?php
declare(strict_types=1);

namespace App\Models;

final class Analytics extends Model
{
  public static function log(int $listingId, ?int $userId, string $eventType, string $ipBin, ?string $ua): void
  {
    $st=self::pdo()->prepare("INSERT INTO analytics_events (listing_id,user_id,event_type,ip,user_agent) VALUES (?,?,?,?,?)");
    $st->execute([$listingId,$userId,$eventType,$ipBin,$ua]);
  }

  public static function statsForListing(int $listingId): array
  {
    $st=self::pdo()->prepare("SELECT event_type, COUNT(*) cnt FROM analytics_events WHERE listing_id=? GROUP BY event_type");
    $st->execute([$listingId]);
    $rows=$st->fetchAll() ?: [];
    $out=['view'=>0,'click_phone'=>0,'click_whatsapp'=>0,'favorite'=>0,'lead'=>0];
    foreach ($rows as $r) $out[$r['event_type']] = (int)$r['cnt'];
    return $out;
  }

  public static function adminDashboard(): array
  {
    $pdo=self::pdo();
    $counts = [];
    foreach (['users','listings','reviews','leads'] as $t) {
      $counts[$t] = (int)$pdo->query("SELECT COUNT(*) c FROM {$t}")->fetch()['c'];
    }
    $counts['pending_listings'] = (int)$pdo->query("SELECT COUNT(*) c FROM listings WHERE status='pending'")->fetch()['c'];
    $counts['pending_reviews']  = (int)$pdo->query("SELECT COUNT(*) c FROM reviews WHERE status='pending'")->fetch()['c'];
    return $counts;
  }
}
