<?php
declare(strict_types=1);

namespace App\Middlewares;

use App\Core\CSRF;

final class CsrfMiddleware {
  public function handle(): void {
    $token = $_POST['_csrf'] ?? null;
    if (!CSRF::validate($token)) {
      http_response_code(419);
      echo "419 - CSRF inválido";
      exit;
    }
  }
}
