<?php
declare(strict_types=1);

namespace App\Core;

final class Router
{
  private array $routes = ['GET'=>[], 'POST'=>[]];

  public function get(string $path, string $handler, array $middlewares = []): void {
    $this->routes['GET'][] = [$path, $handler, $middlewares];
  }
  public function post(string $path, string $handler, array $middlewares = []): void {
    $this->routes['POST'][] = [$path, $handler, $middlewares];
  }

  public function dispatch(string $method, string $uri): void
  {
    $path = parse_url($uri, PHP_URL_PATH) ?: '/';
    $candidates = $this->routes[$method] ?? [];

    foreach ($candidates as [$routePath, $handler, $middlewares]) {
      $pattern = preg_replace('#\{[a-zA-Z_]+\}#', '([^/]+)', $routePath);
      $pattern = '#^' . $pattern . '$#';

      if (preg_match($pattern, $path, $matches)) {
        array_shift($matches);
        $params = $matches;

        foreach ($middlewares as $mwClass) {
          (new $mwClass())->handle();
        }

        [$controller, $action] = explode('@', $handler);
        $fqcn = "App\\Controllers\\{$controller}";
        if (!class_exists($fqcn)) { http_response_code(500); echo "Controller não encontrado"; return; }
        $instance = new $fqcn();
        if (!method_exists($instance, $action)) { http_response_code(500); echo "Ação não encontrada"; return; }

        $instance->$action(...$params);
        return;
      }
    }

    http_response_code(404);
    echo "404 - Página não encontrada";
  }
}
