<?php
declare(strict_types=1);

namespace App\Core;

use Normalizer;

final class Helpers
{
  public static function e(?string $s): string
  {
    return htmlspecialchars($s ?? '', ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8');
  }

  public static function redirect(string $path): never
  {
    header('Location: ' . $path);
    exit;
  }

  public static function ipBinary(): string
  {
    $ip = $_SERVER['REMOTE_ADDR'] ?? '0.0.0.0';
    $packed = @inet_pton($ip);
    return $packed ?: inet_pton('0.0.0.0');
  }

  public static function norm(string $s): string
  {
    $s = Normalizer::normalize($s, Normalizer::FORM_D) ?? $s;
    $s = preg_replace('/\p{Mn}+/u', '', $s) ?? $s;
    $s = mb_strtolower(trim($s));
    $s = preg_replace('/\s+/u', ' ', $s) ?? $s;
    return $s;
  }

  public static function slug(string $s): string
  {
    $s = self::norm($s);
    $s = preg_replace('/[^a-z0-9\s-]/', '', $s) ?? $s;
    $s = preg_replace('/[\s-]+/', '-', $s) ?? $s;
    return trim($s, '-');
  }

  public static function url(string $path): string
  {
    $base = rtrim($_ENV['APP_URL'] ?? '', '/');
    return $base . $path;
  }
}
