<?php
declare(strict_types=1);

namespace App\Controllers;

use App\Services\SearchService;
use App\Models\Category;
use App\Core\Helpers;

final class SearchController extends Controller
{
  public function index(): void
  {
    $svc = new SearchService();
    $results = $svc->search($_GET);
    $categories = Category::all();

    $center = null;
    if (!empty($_GET['lat']) && !empty($_GET['lng'])) {
      $center = ['lat'=>(float)$_GET['lat'], 'lng'=>(float)$_GET['lng']];
    } elseif (!empty($results[0]['lat']) && !empty($results[0]['lng'])) {
      $center = ['lat'=>(float)$results[0]['lat'], 'lng'=>(float)$results[0]['lng']];
    }

    $q = [
      'q' => (string)($_GET['q'] ?? ''),
      'city' => (string)($_GET['city'] ?? ($_ENV['DEFAULT_CITY'] ?? '')),
      'district' => (string)($_GET['district'] ?? ''),
      'type' => (string)($_GET['type'] ?? ''),
      'category' => (string)($_GET['category'] ?? ''),
      'radius' => (string)($_GET['radius'] ?? ''),
      'open_now' => !empty($_GET['open_now']),
      'min_rating' => (string)($_GET['min_rating'] ?? ''),
      'sort' => (string)($_GET['sort'] ?? 'relevance'),
      'lat' => (string)($_GET['lat'] ?? ''),
      'lng' => (string)($_GET['lng'] ?? ''),
    ];

    $this->view('search/index', [
      'results' => $results,
      'categories' => $categories,
      'q' => $q,
      'center' => $center,
    ]);
  }
}
