<?php
declare(strict_types=1);

namespace App\Controllers;

use App\Core\Auth;
use App\Core\Helpers;
use App\Core\RateLimiter;
use App\Models\Report;

final class ReportController extends Controller
{
  public function store(): void
  {
    $targetType = in_array(($_POST['target_type'] ?? ''), ['listing','review'], true) ? $_POST['target_type'] : 'listing';
    $targetId = (int)($_POST['target_id'] ?? 0);
    $reason = trim((string)($_POST['reason'] ?? ''));
    $details = trim((string)($_POST['details'] ?? '')) ?: null;
    $back = $_SERVER['HTTP_REFERER'] ?? '/';

    $key = 'report:' . ($_SERVER['REMOTE_ADDR'] ?? 'ip');
    if (!RateLimiter::hit($key, 10, 60*60)) { http_response_code(429); echo "Muitas denúncias."; return; }

    if ($targetId<=0 || $reason==='') Helpers::redirect($back);

    $uid = Auth::check() ? (int)Auth::user()['id'] : null;
    Report::create($uid, $targetType, $targetId, mb_substr($reason,0,120), $details, Helpers::ipBinary());
    Helpers::redirect($back . (str_contains($back,'?') ? '&' : '?') . 'report=ok');
  }
}
