<?php
declare(strict_types=1);

namespace App\Controllers;

use App\Models\Listing;
use App\Models\Review;
use App\Models\Favorite;
use App\Models\Media;
use App\Models\Analytics;
use App\Core\Auth;
use App\Core\Helpers;

final class ListingController extends Controller
{
  public function show(string $slug): void
  {
    $listing = Listing::findBySlug($slug);
    if (!$listing || ($listing['status'] !== 'active' && (Auth::user()['role'] ?? '') !== 'admin')) {
      http_response_code(404); echo "Perfil não encontrado"; return;
    }

    $cats = Listing::categories((int)$listing['id']);
    $services = Listing::services((int)$listing['id']);
    $media = Listing::media((int)$listing['id']);
    $reviews = Review::forListing((int)$listing['id']);
    $logo = Media::logoPath((int)$listing['id']);
    $hours = Listing::hours((int)$listing['id']);

    $isFav = false;
    if (Auth::check()) $isFav = Favorite::isFav((int)Auth::user()['id'], (int)$listing['id']);

    Analytics::log((int)$listing['id'], Auth::check() ? (int)Auth::user()['id'] : null, 'view', Helpers::ipBinary(), $_SERVER['HTTP_USER_AGENT'] ?? null);

    $this->view('listing/show', compact('listing','cats','services','media','reviews','logo','isFav','hours'));
  }
}
