<?php
declare(strict_types=1);

namespace App\Controllers;

use App\Core\Helpers;
use App\Core\RateLimiter;
use App\Models\Lead;
use App\Models\Listing;
use App\Models\Analytics;
use App\Services\MailService;

final class LeadController extends Controller
{
  public function store(): void
  {
    $listingId = (int)($_POST['listing_id'] ?? 0);
    $name = trim((string)($_POST['name'] ?? ''));
    $phone = trim((string)($_POST['phone'] ?? '')) ?: null;
    $email = trim((string)($_POST['email'] ?? '')) ?: null;
    $message = trim((string)($_POST['message'] ?? ''));
    $slug = (string)($_POST['slug'] ?? '');

    $key = 'lead:' . ($_SERVER['REMOTE_ADDR'] ?? 'ip');
    if (!RateLimiter::hit($key, 10, 60*10)) {
      http_response_code(429); echo "Muitas mensagens. Tente depois."; return;
    }

    if ($listingId<=0 || $name==='' || mb_strlen($message) < 5) {
      Helpers::redirect('/perfil/' . urlencode($slug));
    }

    Lead::create($listingId, $name, $phone, $email, $message, Helpers::ipBinary(), $_SERVER['HTTP_USER_AGENT'] ?? null);
    Analytics::log($listingId, null, 'lead', Helpers::ipBinary(), $_SERVER['HTTP_USER_AGENT'] ?? null);

    // enviar e-mail pro dono (usa email_public se existir; caso contrário, email do user dono)
    $listing = Listing::findBySlug($slug);
    $to = $listing['email_public'] ?: ($listing['email'] ?? null); // pode vir null dependendo do select
    if ($to && filter_var($to, FILTER_VALIDATE_EMAIL)) {
      (new MailService())->send($to, 'Novo contato pelo Guia Local', "Nome: {$name}\nTelefone: {$phone}\nEmail: {$email}\n\nMensagem:\n{$message}");
    }

    Helpers::redirect('/perfil/' . urlencode($slug) . '?lead=ok');
  }
}
