<?php
declare(strict_types=1);

namespace App\Controllers;

use App\Models\Category;
use App\Services\SearchService;
use App\Core\Helpers;

final class CategoryController extends Controller
{
  public function show(string $slug): void
  {
    $cat = Category::findBySlug($slug);
    if (!$cat) { http_response_code(404); echo "Categoria não encontrada"; return; }

    $svc = new SearchService();
    $params = [
      'q' => '',
      'city' => (string)($_GET['city'] ?? ($_ENV['DEFAULT_CITY'] ?? '')),
      'category' => $slug,
      'type' => $cat['type'] === 'both' ? '' : $cat['type'],
    ];
    $results = $svc->search($params);
    $categories = Category::all();

    $this->view('categories/show', compact('cat','results','categories','params'));
  }
}
