<?php
declare(strict_types=1);

namespace App\Controllers;

use App\Core\Auth;
use App\Core\DB;
use App\Core\Helpers;
use App\Models\Listing;
use App\Models\AdminLog;

final class AdminListingController extends Controller
{
  public function index(): void
  {
    Auth::requireRole(['admin']);
    $pdo=DB::pdo();
    $status = in_array(($_GET['status'] ?? 'pending'), ['pending','active','blocked'], true) ? $_GET['status'] : 'pending';
    $rows=$pdo->prepare("SELECT l.*, u.email, a.city,a.district
      FROM listings l JOIN users u ON u.id=l.user_id JOIN addresses a ON a.listing_id=l.id
      WHERE l.status=? ORDER BY l.created_at DESC LIMIT 200");
    $rows->execute([$status]);
    $listings=$rows->fetchAll() ?: [];
    $this->view('admin/listings', compact('listings','status'));
  }

  public function setStatus(): void
  {
    Auth::requireRole(['admin']);
    $id=(int)($_POST['id'] ?? 0);
    $status=in_array(($_POST['status'] ?? ''), ['pending','active','blocked'], true) ? $_POST['status'] : 'pending';
    if ($id>0) {
      Listing::setStatus($id,$status);
      AdminLog::add((int)Auth::user()['id'], 'set_status', 'listing', $id, ['status'=>$status]);
    }
    Helpers::redirect('/admin/listings?status=' . urlencode($status));
  }

  public function setPlan(): void
  {
    Auth::requireRole(['admin']);
    $id=(int)($_POST['id'] ?? 0);
    $plan=in_array(($_POST['plan'] ?? ''), ['free','premium'], true) ? $_POST['plan'] : 'free';
    $days = (int)($_POST['premium_days'] ?? 0);
    $until = null;
    if ($plan === 'premium') $until = date('Y-m-d H:i:s', time() + max(1,$days)*86400);
    if ($id>0) {
      Listing::setPlan($id,$plan,$until);
      AdminLog::add((int)Auth::user()['id'], 'set_plan', 'listing', $id, ['plan'=>$plan,'premium_until'=>$until]);
    }
    Helpers::redirect('/admin/listings');
  }
}
